﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<SearchViewModel>" %>

<div id="searchForm" class="<%=(Model.Items != null) ? "panel collapsed" : "panel" %>">
    <h2><a class="toggle" href="javascript:void(0)" onclick="var a = document.getElementById('searchForm'); a.className = (a.className == 'panel' ? 'panel collapsed' : 'panel'); return false">Activity Search</a></h2>    
    <div class="container">
    <% using (Html.BeginForm<SearchController>(c => c.Advanced(null), FormMethod.Get)) %>
    <% { %>
        <p>
            Select an activity type and enter a location to constrain your search:
        </p>
        <%=Html.ValidationMessage("ActivitySearchCriteria")%>
        <table cellpadding="0">
            <tr>
                <td colspan="2">
                    <label for="ActivityTypeId">Activity:</label><br />
                    <%=Html.DropDownList("ActivityTypeId", Model.SearchFields.ActivityTypes)%>
                </td>
            </tr>
            <tr>
                <td><label for="State">State:</label><br /><%=Html.DropDownList("State", Model.SearchFields.States)%></td>
                <td width="50%"><label for="City">City:</label><br /><%=Html.TextBox("City")%></td>
            </tr>
            <tr>
                <td width="50%"><label for="StreetAddress">Address:</label><br /><%=Html.TextBox("StreetAddress")%></td>
                <td><label for="Zip">Zip:</label><br /><%=Html.TextBox("Zip", null, new { size = 5, maxlength = 5 })%></td>
            </tr>
            <tr>
                <td><label for="Radius">Miles:</label><br /><%=Html.DropDownList("Radius", Model.SearchFields.Miles)%></td>
                <td><br /><input type="submit" value="Search" /></td>
            </tr>
        </table>
    <% } %>
    </div>
</div>
